<?php

namespace App\Mail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
class Verify extends Mailable
{
    use Queueable, SerializesModels;

    public $email;
    public $password;
    public $subjectEmail;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($email,$password,$subjectEmail)
    {
        $this->subjectEmail = $subjectEmail;
        $this->email = $email;
        $this->password = $password;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('auth.verify')->with(['email'=>$this->email,'password'=>$this->password]);
    }
    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function envelope()
    {
        return new Envelope(
            subject:$this->subjectEmail,
        );
    }

    /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */
    public function content()
    {
        return new Content(
            view: 'auth.verify',
            with: [
                'email'=>$this->email,
                'password'=>$this->password
            ],
        );
    }
}
